/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.designer;

import filenet.vw.api.VWException;
import filenet.vw.api.VWUserInfo;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWSessionInfo;
import java.awt.Frame;

public class VWSIMDesignerPreferences {
    private boolean m_bValidateWorkflowDefsWithScenario = true;
    private boolean m_bAddCheckIn = true;
    private boolean m_bCreateDefaultEntries = true;
    private Frame m_parentFrame = null;
    private VWSessionInfo m_sessionInfo = null;

    public VWSIMDesignerPreferences(Frame parentFrame, VWSessionInfo sessionInfo) {
        this.m_parentFrame = parentFrame;
        this.m_sessionInfo = sessionInfo;
    }

    public void initPreferenceSettings() {
        try {
            VWUserInfo userInfo = this.m_sessionInfo.getSession().fetchCurrentUserInfo();
            if (userInfo != null) {
                Object obj = userInfo.getFieldValue("sim_designer_validate_wfldefs");
                if (obj != null) {
                    this.m_bValidateWorkflowDefsWithScenario = (Boolean)obj;
                }
                if ((obj = userInfo.getFieldValue("sim_designer_add_checkin")) != null) {
                    this.m_bAddCheckIn = (Boolean)obj;
                }
                if (!this.m_sessionInfo.getCanSaveToDMS()) {
                    this.m_bAddCheckIn = false;
                }
                if ((obj = userInfo.getFieldValue("sim_designer_create_default_entries")) != null) {
                    this.m_bCreateDefaultEntries = (Boolean)obj;
                }
            }
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean getShouldValidateWorkflowDefsWithScenario() {
        return this.m_bValidateWorkflowDefsWithScenario;
    }

    public void setShouldValidateWorkflowDefsWithScenario(boolean bFlag) {
        this.m_bValidateWorkflowDefsWithScenario = bFlag;
    }

    public boolean getShouldAddCheckIn() {
        return this.m_bAddCheckIn;
    }

    public void setShouldAddCheckIn(boolean bFlag) {
        this.m_bAddCheckIn = bFlag;
    }

    public boolean getShouldCreateDefaultEntries() {
        return this.m_bCreateDefaultEntries;
    }

    public void setShouldreateDefaultEntries(boolean bFlag) {
        this.m_bCreateDefaultEntries = bFlag;
    }

    public void savePreferencesSettings() {
        try {
            VWUserInfo userInfo = this.m_sessionInfo.getSession().fetchCurrentUserInfo();
            if (userInfo != null) {
                userInfo.setFieldValue("sim_designer_validate_wfldefs", new Boolean(this.m_bValidateWorkflowDefsWithScenario));
                userInfo.setFieldValue("sim_designer_add_checkin", new Boolean(this.m_bAddCheckIn));
                userInfo.setFieldValue("sim_designer_create_default_entries", new Boolean(this.m_bCreateDefaultEntries));
                userInfo.save();
            }
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
        }
    }
}

